function AICselect(pdata)

NumPoints = numel(pdata.Xdata);
deg = 0; 
while (deg>=0 & deg<=NumPoints-1)
  [P,S] = polyfit(pdata.Xdata,pdata.Ydata,deg);
  loglike = NumPoints*log(1/(pdata.NoiseLevel*sqrt(2*pi))) ...
            - 1/(2*pdata.NoiseLevel^2)*S.normr^2;
  AIC(deg+1) = 2*(deg+1) - 2*loglike;
  if (deg == 0)
    disp(['Degree: ',num2str(deg),' AIC: ',num2str(AIC(deg+1)),': BASELINE']);
  elseif AIC(deg + 1) < AIC(deg)
    disp(['Degree: ',num2str(deg),' AIC: ',num2str(AIC(deg+1)),': BETTER']);
  else
    disp(['Degree: ',num2str(deg),' AIC: ', num2str(AIC(deg+1)),': WORSE']);
    break
  end  
  deg = deg + 1;
end
disp(['AIC deems the answer DEGREE ',num2str(deg - 1)]);
disp(['RECALL: The polynomial that generated the data had DEGREE ',...
       num2str(numel(pdata.Polynomial)-1)]);

